-- REGIONS
--
INSERT INTO public."HET_REGION"
  ("REGION_ID", "NAME", "REGION_NUMBER", "MINISTRY_REGION_ID", "START_DATE", "END_DATE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'South Coast', '1', '1', '1900-01-01', NULL, 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_REGION"
  ("REGION_ID", "NAME", "REGION_NUMBER", "MINISTRY_REGION_ID", "START_DATE", "END_DATE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, 'Southern Interior', '2', '2', '1900-01-01', NULL, 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
      
INSERT INTO public."HET_REGION"
  ("REGION_ID", "NAME", "REGION_NUMBER", "MINISTRY_REGION_ID", "START_DATE", "END_DATE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, 'Northern', '3', '3', '1900-01-01', NULL, 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
      
INSERT INTO public."HET_REGION"
  ("REGION_ID", "NAME", "REGION_NUMBER", "MINISTRY_REGION_ID", "START_DATE", "END_DATE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, 'NON-BC', '99', '99', '1900-01-01', NULL, 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
      
INSERT INTO public."HET_REGION"
  ("REGION_ID", "NAME", "REGION_NUMBER", "MINISTRY_REGION_ID", "START_DATE", "END_DATE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 'Unknown', '999', '999', '1900-01-01', NULL, 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
ALTER SEQUENCE public."HET_REGION_ID_seq" RESTART WITH 6;   
   
-- **************************************************************************************
-- DISTRICTS

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, '1', 'Lower Mainland', '1900-01-01', NULL, '1', '1',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, '2', 'Vancouver Island', '1900-01-01', NULL, '2', '1',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, '3', 'Rocky Mountain', '1900-01-01', NULL, '3', '2',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, '4', 'West Kootenay', '1900-01-01', NULL, '4', '2',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, '5', 'Okanagan-Shuswap', '1900-01-01', NULL, '5', '2',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   
   
INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (6, '6', 'Thompson-Nicola', '1900-01-01', NULL, '6', '2',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (7, '7', 'Cariboo', '1900-01-01', NULL, '7', '2',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (8, '8', 'Peace', '1900-01-01', NULL, '8', '3',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (9, '9', 'Fort George', '1900-01-01', NULL, '9', '3',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (10, '10', 'Bulkley-Stikine', '1900-01-01', NULL, '10', '3',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (11, '11', 'Skeena', '1900-01-01', NULL, '11', '3',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (99, '99', 'NON-BC', '1900-01-01', NULL, '99', '4',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_DISTRICT"
  ("DISTRICT_ID", "DISTRICT_NUMBER", "NAME", "START_DATE", "END_DATE", "MINISTRY_DISTRICT_ID", "REGION_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (999, '999', 'Unknown', '1900-01-01', NULL, '999', '5',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
ALTER SEQUENCE public."HET_DISTRICT_ID_seq" RESTART WITH 1000;   

-- **************************************************************************************
-- CONDITION TYPE

INSERT INTO public."HET_CONDITION_TYPE"
  ("DISTRICT_ID", "CONDITION_TYPE_CODE", "DESCRIPTION", "ACTIVE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
SELECT DISTINCT "DISTRICT_ID" AS DISTRICT_ID,
   'COND_1', 'Plus fuel price adjustment', true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()
FROM public."HET_DISTRICT";
   
INSERT INTO public."HET_CONDITION_TYPE"
  ("DISTRICT_ID", "CONDITION_TYPE_CODE", "DESCRIPTION", "ACTIVE", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
SELECT DISTINCT "DISTRICT_ID" AS DISTRICT_ID,
   'COND_2', 'Travel as per time card, if applicable', true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()
FROM public."HET_DISTRICT";   

-- **************************************************************************************
-- EQUIPMENT TYPE

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('MISCELLANEOUS', '0', '0', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('DRILLING EQUIPMENT', '0', '1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('COMPRESSORS', '0', '1.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PNEUMATIC TOOLS AND ACCESSORIES', '0', '1.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACK OR CRAWLER DRILLS – SELF PROPELLED', '0', '1.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('STANDARD AIR TRACK OR TANK DRILL OUTFIT', '0', '1.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('HYDRAULIC DRILL OUTFIT', '0', '1.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('DOWN THE HOLE PERCUSSION DRILL OUTFIT', '0', '1.6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('LOW PRESSURE ROTARY BLASTHOLE DRILL OUTFIT', '0', '1.7', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('HYDRAULIC DRILL ON EXCAVATORS', '0', '1.8', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PAVING AND SWEEPING EQUIPMENT', '0', '2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('DISTRIBUTORS', '0', '2.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PAVERS AND SPREADERS – SELF PROPELLED', '0', '2.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SPREADERS – TOWED OR ATTACHMENT', '0', '2.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CURBING MACHINE', '0', '2.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SWEEPERS – SELF PROPELLED', '0', '2.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SWEEPERS – TOWED OR ATTACHMENT', '0', '2.6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PAVEMENT MILLERS AND PROFILERS', '0', '2.7', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CLEANING EQUIPMENT', '0', '3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SAND BLASTERS', '0', '3.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('STEAM CLEANERS', '0', '3.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('HIGH PRESSURE WASHER OUTFIT (TRUCK AND/OR TRAILER MOUNTED)', '0', '3.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE EQUIPMENT', '0', '4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE BUCKETS', '0', '4.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE BUGGIES', '0', '4.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE VIBRATORS', '0', '4.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE MIXERS', '0', '4.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRANSIT MIXERS AND CONCRETE PUMP TRUCKS', '0', '4.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CONCRETE PUMPING OR PLACING EQUIPMENT', '0', '4.6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SCALES', '0', '5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SEMI-PORTABLE – MOTOR TRUCKS', '0', '5.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());      

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ELECTRICAL EQUIPMENT', '0', '6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('GENERATING SETS', '0', '6.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WELDERS', '0', '6.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WELDING OUTFITS', '0', '6.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('LIGHT TOWERS', '0', '6.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('EXCAVATORS', '0', '7', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('MINI/COMPACT EXCAVATORS – OPERATING WEIGHT UNDER 21,000 LBS', '0', '7.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WHEEL EXCAVATORS – OPERATING WEIGHT OVER 20,000 LBS', '0', '7.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('HEAVY HYDRAULIC EXCAVATORS – OPERATING WEIGHT OVER 21,000 LBS', '0', '7.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('HYDRAULIC EXCAVATOR ATTACHMENTS', '0', '7.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('EXCAVATORS – CABLE OPERATED, DRAGLINE OR CLAM', '0', '7.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('GRADERS', '0', '8', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('GRADERS – ARTICULATED FRAME', '0', '8.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('GRADERS – GRADER ATTACHMENTS', '0', '8.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('LIFTING EQUIPMENT', '0', '9', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('FORK LIFTS', '0', '9.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CRANES - DIESEL OR GAS', '0', '9.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());      

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CRANE ATTACHMENTS', '0', '9.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('LOADERS', '0', '10', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CRAWLER FRONT END LOADERS', '0', '10.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('RUBBER TIRED FRONT-END LOADERS (4 WHEEL DRIVE)', '0', '10.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SAWS AND BRUSH CUTTERS', '0', '11', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('POWER SAWS', '0', '11.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRAILER/SKID MOUNTED', '0', '11.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('CARRIER MOUNTED BRUSH CUTTERS', '0', '11.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TUB GRINDERS (HOGGERS)', '0', '11.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PUMPS', '0', '12', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PUMPS – INCLUDING 1 LENGTH INTAKE AND DISCHARGE HOSE', '0', '12.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('PUMPING HOSE', '0', '12.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS', '0', '13', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    
   
INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – SELF PROPELLED – STEEL WHEEL AND PNEUMATIC TIRED', '0', '13.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – SELF PROPELLED – SANITATION OR RECLAMATION COMPACTORS', '0', '13.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – SELF PROPELLED – VIBRATORY (RUBBER AND STEEL)', '0', '13.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – SELF PROPELLED – VIBRATORY (TANDEM AND STEEL)', '0', '13.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());      
   
INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – TOWED – SHEEPSFOOT AND GRIND', '0', '13.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());      

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('ROLLERS – TOWED – PNEUMATIC TIRED OR VIBRATORY STEEL WHEEL', '0', '13.6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WALK BEHIND VIBRATORY ROLLERS', '0', '13.7', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WALK BEHIND PLATE TAMPERS (FLAT PLATE)', '0', '13.8', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SCRAPERS', '0', '14', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SCRAPERS – TOWED', '0', '14.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SCRAPERS – ELEVATING (1 ENGINE, 2 ENGINES)', '0', '14.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS', '0', '15', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS – CRAWLER TRACTOR ATTACHMENTS', '0', '15.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS – CRAWLER TRACTORS', '0', '15.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS – TRACTOR AND BACKHOE ATTACHMENTS', '0', '15.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS – RUBBER TIRED 4x2 AND 4x4', '0', '15.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRACTORS – BACKHOES 4x2 AND 4x4', '0', '15.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRUCKS – TRAILERS AND ATTACHMENTS', '0', '16', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   
   
INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('DUMP TRUCKS – GAS OR DIESEL', '0', '16.1', true, 2, 0, 600, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('MISCELLANEOUS TRANSPORTATION AND HAUL TRUCKS', '0', '16.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('TRUCK ATTACHMENTS AND TILT TRAILERS', '0', '16.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('WATER TRUCKS AND SEWER CLEANERS', '0', '16.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());        

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SNOW AND MUSKEG TRANSPORT', '0', '16.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());         
 
INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('MANLIFTS AND AERIAL LIFT PLATFORMS', '0', '16.6', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       
 
INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('OFF-HIGHWAY HEAVY DUTY DUMP TRUCKS (RIGID FRAME)', '0', '16.7', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());         

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('OFF-HIGHWAY HEAVY DUTY DUMP TRUCKS (ARTICULATED)', '0', '16.8', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('FORESTRY', '0', '17', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('GRAPPLE/LINE SKIDDERS – RUBBER TIRES', '0', '17.1', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('FELLER BUNCHER', '0', '17.2', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('SKIDDERS', '0', '17.3', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());       

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('EXCAVATOR – FORESTRY', '0', '17.4', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_EQUIPMENT_TYPE"
  ("NAME", "BLUE_BOOK_RATE_NUMBER", "BLUE_BOOK_SECTION", "IS_DUMP_TRUCK", "NUMBER_OF_BLOCKS", "EXTEND_HOURS", "MAXIMUM_HOURS", "MAX_HOURS_SUB", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('EXCAVATOR – ROAD BUILDERS', '0', '17.5', false, 1, 0, 300, 0,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

-- **************************************************************************************
-- PERMISSION

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Login', 'Login', 'Permission to login to the application and perform all Clerk functions within their designated District',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, 'UserManagement', 'User Management', 'Gives the user access to the User Management screens',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, 'RolesAndPermissions', 'Roles and Permissions', 'Gives the user access to the Roles and Permissions screens',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, 'Admin', 'Administration', 'Allows the user to perform special administrative tasks',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 'ImportData', 'Import Legacy Data', 'Enables the user to import data from the legacy system',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (6, 'CodeTableManagement', 'Code Table Management', 'Gives the user access to the Code Table Management screens',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (7, 'DistrictCodeTableManagement', 'District Code Table Management', 'Gives the user access to the District Code Table Management screens',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (8, 'BusinessLogin', 'Business Login', 'Permission to login to the business or owner facing application',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (9, 'DistrictRollover', 'District Rollover', 'Permission to kickoff the annual district rollover process',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_PERMISSION"
  ("PERMISSION_ID", "CODE", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (10, 'Version', 'Version', 'Permission to view application''s version page',
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
ALTER SEQUENCE public."HET_PERMISSION_ID_seq" RESTART WITH 10; 

-- **************************************************************************************
-- ROLE

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Administrator', 'System Administrator; full access to the whole system', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, 'Data Conversion', 'Can import data into HETS', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, 'HETS Application Administrator', 'HETS User with administrative permissions', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, 'HETS District User', 'HETS Clerk', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 'HETS Manager', 'HETS District User with additional permissions', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_ROLE"
  ("ROLE_ID", "NAME", "DESCRIPTION", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (6, 'Business BCeID User', 'External Business Account', 
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     
   
ALTER SEQUENCE public."HET_ROLE_ID_seq" RESTART WITH 6; 

-- **************************************************************************************
-- ROLE/PERMISSION

-- Administrator
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (7, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (6, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (3, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (4, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (5, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (9, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (10, 1, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

-- Data Conversion
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 2, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());
 
-- HETS Application Administrator
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (7, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (6, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (9, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (10, 3, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());
 
-- HETS Clerk
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 4, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()); 
   
-- HETS Manager
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 5, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (7, 5, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());   
   
-- Business User
INSERT INTO public."HET_ROLE_PERMISSION"
  ("PERMISSION_ID", "ROLE_ID", "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (8, 6, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());   
      
-- **************************************************************************************
-- USER

INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Litton', 'Paul', 'PML', 'plitton', 'IDIR', NULL, 'paul.litton@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, 'Lyttle', 'Mike', 'ML', 'miklyttl', 'IDIR', NULL, 'mikelyttle@gmail.com', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, 'Bhargava', 'Devashish', 'DB', 'dbhargav', 'IDIR', NULL, 'devashish.bhargava@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, 'Jones', 'Chrystal', 'CJ', 'chrjones', 'IDIR', NULL, 'chrystal.jones@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 'Test', 'Hets', 'TH', 'trhetsat', 'IDIR', NULL, 'trhetsat@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     
  
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (6, 'Bruun', 'Karsten', 'KB', 'kbruun', 'IDIR', NULL, 'karsten.bruun@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     
  
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (7, 'Allan', 'Clare', 'CA', 'cgallan', 'IDIR', NULL, 'clare.g.allan@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     
   
  
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (8, 'Barabas', 'Julian', 'JB', 'jbarabas', 'IDIR', NULL, 'julian.barabas@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    

  
INSERT INTO public."HET_USER"
  ("USER_ID", "SURNAME", "GIVEN_NAME", "INITIALS", "SM_USER_ID", "SM_AUTHORIZATION_DIRECTORY", "GUID", "EMAIL", "ACTIVE", "DISTRICT_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (9, 'Smith', 'James', 'JS', 'jasmith', 'IDIR', NULL, 'james.smith@gov.bc.ca', true, 10,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   
   
   
ALTER SEQUENCE public."HET_USER_ID_seq" RESTART WITH 9; 
   
-- **************************************************************************************
-- USER/ROLE

INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 1, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
 
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 2, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
 
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 3, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   
   
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 4, 3,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
   
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 5, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  

INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 6, 2,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 
      
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 7, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());     
   
INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 8, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   

INSERT INTO public."HET_USER_ROLE"
  ("EFFECTIVE_DATE", "EXPIRY_DATE", "USER_ID", "ROLE_ID", 
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('1900-01-01', NULL, 9, 1,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());      
   
-- **************************************************************************************
-- USER/DISTRICT

INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
 
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (2, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
 
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (3, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());   
   
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (4, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());  
   
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (5, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 
   
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (6, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 
   
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (7, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
      
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (8, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
      
INSERT INTO public."HET_USER_DISTRICT"
  ("USER_ID", "DISTRICT_ID", "IS_PRIMARY",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (9, 10, true,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());    
   
-- **************************************************************************************
-- PROVINCIAL RATE TYPE
   
INSERT INTO public."HET_PROVINCIAL_RATE_TYPE"
  ("RATE_TYPE", "ACTIVE", "OVERTIME", "DESCRIPTION", "IS_INCLUDED_IN_TOTAL", "IS_PERCENT_RATE",
   "IS_RATE_EDITABLE", "PERIOD_TYPE", "RATE", "IS_IN_TOTAL_EDITABLE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('OVERTIME_8HR', true, true, 'Overtime After 8 Hours', false, false, false, 'Weekly', 36, false,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW()); 
   
INSERT INTO public."HET_PROVINCIAL_RATE_TYPE"
  ("RATE_TYPE", "ACTIVE", "OVERTIME", "DESCRIPTION", "IS_INCLUDED_IN_TOTAL", "IS_PERCENT_RATE",
   "IS_RATE_EDITABLE", "PERIOD_TYPE", "RATE", "IS_IN_TOTAL_EDITABLE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  ('OVERTIME_12HR', true, true, 'Overtime After 12 Hours', false, false, false, 'Weekly', 48, false,
   NULL, NULL, 'HETS', NOW(), 
   NULL, NULL, 'HETS', NOW());
   
-- **************************************************************************************
-- RENTAL REQUEST STATUS

INSERT INTO public."HET_RENTAL_REQUEST_STATUS_TYPE"
  ("RENTAL_REQUEST_STATUS_TYPE_ID", "RENTAL_REQUEST_STATUS_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'In Progress', 'In Progress', 'In Progress', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Complete', 'Complete', 'Complete', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());
 
ALTER SEQUENCE public."HET_RENTAL_REQUEST_STATUS_TYPE_ID_seq" RESTART WITH 2; 
 
-- **************************************************************************************
-- RENTAL AGREEMENT STATUS

INSERT INTO public."HET_RENTAL_AGREEMENT_STATUS_TYPE"
  ("RENTAL_AGREEMENT_STATUS_TYPE_ID", "RENTAL_AGREEMENT_STATUS_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Active', 'Active', 'Active', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Complete', 'Complete', 'Complete', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_RENTAL_AGREEMENT_STATUS_TYPE_ID_seq" RESTART WITH 2; 
  
-- **************************************************************************************
-- RATE PERIOD TYPE

INSERT INTO public."HET_RATE_PERIOD_TYPE"
  ("RATE_PERIOD_TYPE_ID", "RATE_PERIOD_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Weekly', 'Weekly', 'Weekly', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Hr', 'Hourly', 'Hourly', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (3, 'Daily', 'Daily', 'Daily', 3, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (4, 'Monthly', 'Monthly', 'Monthly', 4, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (5, 'Negotiated', 'Negotiated', 'Negotiated', 5, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_RATE_PERIOD_TYPE_ID_seq" RESTART WITH 5; 
 
-- **************************************************************************************
-- TIME PERIOD TYPE

INSERT INTO public."HET_TIME_PERIOD_TYPE"
  ("TIME_PERIOD_TYPE_ID", "TIME_PERIOD_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Week', 'Week', 'Week', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Day', 'Day', 'Day', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (3, 'Month', 'Month', 'Month', 3, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_TIME_PERIOD_TYPE_ID_seq" RESTART WITH 3;  
  
-- **************************************************************************************
-- PROJECT STATUS

INSERT INTO public."HET_PROJECT_STATUS_TYPE"
  ("PROJECT_STATUS_TYPE_ID", "PROJECT_STATUS_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Active', 'Active', 'Active', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Completed', 'Completed', 'Completed', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_PROJECT_STATUS_TYPE_ID_seq" RESTART WITH 2;  
  
-- **************************************************************************************
-- OWNER STATUS

INSERT INTO public."HET_OWNER_STATUS_TYPE"
  ("OWNER_STATUS_TYPE_ID", "OWNER_STATUS_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Archived', 'Archived', 'Archived', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Unapproved', 'Unapproved', 'Unapproved', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (3, 'Approved', 'Approved', 'Approved', 3, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_OWNER_STATUS_TYPE_ID_seq" RESTART WITH 3;   
  
-- **************************************************************************************
-- EQUIPMENT STATUS

INSERT INTO public."HET_EQUIPMENT_STATUS_TYPE"
  ("EQUIPMENT_STATUS_TYPE_ID", "EQUIPMENT_STATUS_TYPE_CODE", "DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'Archived', 'Archived', 'Archived', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'Pending', 'Pending', 'Pending', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (3, 'Unapproved', 'Unapproved', 'Unapproved', 3, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (4, 'Approved', 'Approved', 'Approved', 4, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());

ALTER SEQUENCE public."HET_EQUIPMENT_STATUS_TYPE_ID_seq" RESTART WITH 4;   
  
-- **************************************************************************************  
 -- MIME TYPE

 INSERT INTO public."HET_MIME_TYPE"
  ("MIME_TYPE_ID", "MIME_TYPE_CODE","DESCRIPTION", "SCREEN_LABEL", "DISPLAY_ORDER", "IS_ACTIVE",
   "APP_CREATE_USER_DIRECTORY", "APP_CREATE_USER_GUID", "APP_CREATE_USERID", "APP_CREATE_TIMESTAMP", 
   "APP_LAST_UPDATE_USER_DIRECTORY", "APP_LAST_UPDATE_USER_GUID", "APP_LAST_UPDATE_USERID", 
   "APP_LAST_UPDATE_TIMESTAMP")
VALUES 
  (1, 'PNG', 'image/png', 'PNG', 1, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (2, 'PDF', 'application/pdf', 'PDF', 2, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),  
  (3, 'JPEG', 'application/jpeg', 'JPEG', 3, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (4, 'JPG', 'application/jpeg', 'JPG', 4, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),  
  (5, 'GIF', 'application/gif', 'GIF', 5, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (6, 'TIF', 'application/tiff', 'TIF', 6, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (7, 'TIFF', 'application/tiff', 'TIFF', 7, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),  
  (8, 'TXT', 'text/plain', 'TXT', 8, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (9, 'DOC', 'application/msword', 'Word Document (*.doc)', 9, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (10, 'DOCX', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'Word Document (*.docx)', 10, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (11, 'XLS', 'application/vnd.ms-excel', 'Excel Workbook (*.xls)', 11, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW()),
  (12, 'MSWORD', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'Excel Workbook (*.xlsx)', 12, true, NULL, NULL, 'HETS', NOW(), NULL, NULL, 'HETS', NOW());
  
ALTER SEQUENCE public."HET_MIME_TYPE_ID_seq" RESTART WITH 12;   
 

    
  
   
   
   
   